var command = [];

/**
 * 初始化标签
 * @param height 标签高度。单位：点（或像素）。
 * @param offset 标签偏移。单位：点（或像素）。
 * @param copies 打印份数。
 */
function addInitializePrinter(height, offset, copies) {
    var c = {};
    c["tag"] = "INIT";
    c["height"] = height;
    c["offset"] = offset;
    c["copies"] = copies;

    command.push(c);
}

/**
 * 添加文本内容。
 * @param font 字体，font有效值为0,1,2,3,4,5,6,7,8,20,24,28,55,56,57,88,89,90,91。
 * @param x 文本横坐标，int类型。
 * @param y 文本纵坐标，int类型。
 * @param text 文本内容，String类型
 * @param size 字体尺寸。  font和size决定字体尺寸，具体提大小参考《优博讯面单打印机编程手册》TEXT描述
 */
function addText(font, x, y, text, size) {

	var c = {};
	c["tag"] = "TEXT";
	c["font"] = font;
	c["bold"] = size;
	c["x"] = x;
	c["y"] = y;
	c["value"] = text;

	command.push(c)
}

/**
 * 添加文本内容，旋转90°。
 * @param font 字体，font有效值为0,1,2,3,4,5,6,7,8,20,24,28,55,56,57,88,89,90,91。
 * @param x 文本横坐标，int类型。
 * @param y 文本纵坐标，int类型。
 * @param text 文本内容，String类型。
 * @param size 字体尺寸。  font和size决定字体尺寸，具体提大小参考《优博讯面单打印机编程手册》TEXT描述
 */
function addText90(font, x, y, text, size) {
	var c = {};
	c["tag"] = "TEXT90";
	c["font"] = font;
	c["bold"] = size;
	c["x"] = x;
	c["y"] = y;
	c["value"] = text;

	command.push(c);
}

/**
 * 添加文本内容，旋转180°。
 * @param font 字体，font有效值为0,1,2,3,4,5,6,7,8,20,24,28,55,56,57,88,89,90,91。
 * @param x 文本横坐标，int类型。
 * @param y 文本纵坐标，int类型。
 * @param text 文本内容，String类型。
 * @param size 字体尺寸。  font和size决定字体尺寸，具体提大小参考《优博讯面单打印机编程手册》TEXT描述。
 */
function addText180(font, x, y, text, size) {

	var c = {};
	c["tag"] = "TEXT180";
	c["font"] = font;
	c["bold"] = size;
	c["x"] = x;
	c["y"] = y;
	c["value"] = text;

	command.push(c);
}

/**
 * 添加文本内容，旋转270°。
 * @param font 字体，font有效值为0,1,2,3,4,5,6,7,8,20,24,28,55,56,57,88,89,90,91。
 * @param x 文本横坐标，int类型。
 * @param y 文本纵坐标，int类型。
 * @param text 文本内容，String类型。
 * @param size 字体尺寸。  font和size决定字体尺寸，具体提大小参考《优博讯面单打印机编程手册》TEXT描述
 */
function addText270(font, x, y, text, size) {

	var c = {};
	c["tag"] = "TEXT270";
	c["font"] = font;
	c["bold"] = size;
	c["x"] = x;
	c["y"] = y;
	c["value"] = text;

	command.push(c);
}

/**
 * 打印流水号
 * @param value 流水号值。
 */
function addCount(value) {

    var c = {};
    c["tag"] = "COUNT";
    c["value"] = value;

    command.push(c);
}

/**
 * 字体放大
 * @param w 放大字体宽度，取值范围为1 ≤ w ≤ 16。
 * @param h 放大字体高度，取值范围为1 ≤ h ≤ 16。
 */
function addSetmag(w, h) {

    var c = {};
    c["tag"] = "SETMAG";
    c["w"] = w;
    c["h"] = h;

    command.push(c);
}

/**
 * 添加横向一维条码
 * @param type  条码类型。
 * @param width 窄条单元宽度。
 * @param ratio 宽条与窄条的比率。ratio可设置值为0,1,2,3,4,20,21,22,23,24,25,26,27,28,29,30。
 * @param height 条码高度。
 * @param x 条码横坐标。
 * @param y 条码纵坐标。
 * @param text 条码内容。
 */
function addBarcode(type, width, ratio, height, x, y, text) {

    var c = {};
    c["tag"] = "BARCODE";
    c["type"] = type;
    c["ratio"] = ratio;
    c["height"] = height;
    c["width"] = width;
    c["x"] = x;
    c["y"] = y;
    c["value"] = text;

    command.push(c);
}

/**
 * 添加纵向一维条码
 * @param type 条码类型。可设置值为UPCA，UPCE，EAN13，EAN8，CODE39，CODE93，CODE128，CODABAR。
 * @param width 窄条单元宽度。
 * @param ratio 宽条与窄条的比率。ratio可设置值为0,1,2,3,4,20,21,22,23,24,25,26,27,28,29,30。
 * @param height 条码高度。
 * @param x 条码横坐标。
 * @param y 条码纵坐标。
 * @param text 条码内容。
 */
function addVBarcode(type, width, ratio, height, x, y, text) {
    var c = {};
    c["tag"] = "VBARCODE";
    c["type"] = type;
    c["ratio"] = ratio;
    c["height"] = height;
    c["width"] = width;
    c["x"] = x;
    c["y"] = y;
    c["value"] = text;

    command.push(c);
}

/**
 * 文本形式显示条码内容
 * @param font 字体。font有效值为0,1,2,3,4,5,6,7,8,20,24,28,55,56,57,88,89,90,91。
 * @param offset 文本与条码的距离。
 */
function addBarcodeText(font, offset) {
    var c = {};
    c["tag"] = "BARCODE-TEXT";
    c["font"] = font;
    c["offset"] = offset;
    command.push(c);
}

/**
 * 添加横向二维码
 * @param level 二维码纠错等级。
 * @param mode 二维码输入模式，mode可设置值为M，A。M为手动，A为自动。
 * @param x 二维码横坐标。
 * @param y 二维码纵坐标。
 * @param n QRCode规范编号，可设置值为1或2，推荐设置为2。
 * @param u 二维码模块的单元宽度/单位高度。取值范围为1 ≤ u ≤ 32，默认为6。
 * @param text 二维码内容。
 */
function addBQrcode(level, mode, x, y, n, u, text) {
    var c = {};
    c["tag"] = "QRCODE";
    c["level"] = level;
    c["mode"] = mode;
    c["x"] = x;
    c["y"] = y;
    c["n"] = n;
    c["u"] = u;
    c["value"] = text;

    command.push(c);
}

/**
 * 添加纵向二维码
 * @param level 二维码纠错等级。
 * @param mode 二维码输入模式，mode可设置值为M，A。M为手动，A为自动。
 * @param x 二维码横坐标。
 * @param y 二维码纵坐标。
 * @param n QRCode规范编号，可设置值为1或2，推荐设置为2。
 * @param u 二维码模块的单元宽度/单位高度。取值范围为1 ≤ u ≤ 32，默认为6。
 * @param text 二维码内容。
 */
function addVBQrcode(level, mode, x, y, n, u, text) {
    var c = {};
    c["tag"] = "VBQRCODE";
    c["level"] = level;
    c["mode"] = mode;
    c["x"] = x;
    c["y"] = y;
    c["n"] = n;
    c["u"] = u;
    c["value"] = text;

    command.push(c);
}

/**
 * 设置纸张宽度
 * @param width 纸张宽度。单位：点（或像素）。
 */
function addPageWidth(width) {
    var c = {};
    c["tag"] = "PAGE-WIDTH";
    c["width"] = width;
    command.push(c);
}

/**
 * 添加图片
 * @param x 图片横坐标。
 * @param y 图片纵坐标。
 * @param width 图片宽度。80打印机最大可打印范围为576点（或像素）。单位：点（或像素）。
 * @param threshold 图片二值化阈值。取值范围为1 ≤ threshold ≤ 255。
 * @param data 图片base64编码后的数据。
 */
function addBitmap(x, y, width, threshold, data) {
    var c = {};
    c["tag"] = "BITMAP";
    c["x"] = x;
    c["y"] = y;
    c["threshold"] = threshold;
    c["width"] = width;
    c["value"] = data;

    command.push(c);
}

/**
 * 添加图片
 * @param x 图片横坐标。
 * @param y 图片纵坐标。
 * @param width 图片宽度。80打印机最大可打印范围为576点（或像素）。单位：点（或像素）。
 * @param contrastRatio 图片对比度。float类型，取值范围为-1.0f ≤ contrastRatio ≤ 4.0f。
 * @param brightness 图片亮度。float类型，取值范围为-1.0f ≤ brightness ≤ 5.0f。
 * @param data 图片base64编码后的数据。
 */
function addBitmapByMethod(x, y, width, contrastRatio, brightness, data) {
    var c = {};
    c["tag"] = "BITMAP-METHOD";
    c["x"] = x;
    c["y"] = y;
    c["width"] = width;
    c["contrastRatio"] = contrastRatio;
    c["brightness"] = brightness;
    c["value"] = data;

    command.push(c);
}

/**
 * 添加矩形
 * @param x 矩形起始横坐标。
 * @param y 矩形起始纵坐标。
 * @param xEnd 矩形结束横坐标。
 * @param yEnd 矩形结束纵坐标。
 * @param width 矩形线宽。单位：点（或像素）。
 */
function addBox(x, y, xEnd, yEnd, width) {
    var c = {};
    c["tag"] = "BOX";
    c["x"] = x;
    c["y"] = y;
    c["xEnd"] = xEnd;
    c["yEnd"] = yEnd;
    c["width"] = width;

    command.push(c);
}

/**
 * 添加直线
 * @param x 直线起始横坐标。
 * @param y 直线起始纵坐标。
 * @param xEnd 直线结束横坐标。
 * @param yEnd 直线结束纵坐标。
 * @param width 直线线宽。单位：点（或像素）。
 */
function addLine(x, y, xEnd, yEnd, width) {
    var c = {};
    c["tag"] = "LINE";
    c["x"] = x;
    c["y"] = y;
    c["xEnd"] = xEnd;
    c["yEnd"] = yEnd;
    c["width"] = width;

    command.push(c);
}

/**
 * 添加反白区域
 * @param x 反白区域起始横坐标。
 * @param y 反白区域起始纵坐标。
 * @param xEnd 反白区域结束横坐标。
 * @param yEnd 反白区域结束纵坐标。
 * @param width 反白区域高度。单位：点（或像素）。
 */
function addInverseLine(x, y, xEnd, yEnd, width) {
    var c = {};
    c["tag"] = "INVERSE-LINE";
    c["x"] = x;
    c["y"] = y;
    c["xEnd"] = xEnd;
    c["yEnd"] = yEnd;
    c["width"] = width;

    command.push(c);
}

/**
 * 添加对齐方式
 * @param align 对齐方式。String类型，可设置值为CENTER，LEFT，RIGHT。
 * @param end 对齐结束点。int类型，一般使用打印头的宽度。
 */
function addJustification(align, end) {
    var c = {};
    c["tag"] = "JUSTIFICATION";
    c["align"] = align;
    c["end"] = end;

    command.push(c);
}

/**
 * 添加水印
 * @param font 水印字体；font有效值为0,1,2,3,4,5,6,7,8,20,24,28,55,56,57,88,89,90,91。
 * @param size 水印字体大小。
 * @param x 水印横坐标。单位：点（或像素）。
 * @param y 水印纵坐标。单位：点（或像素）。
 * @param n 水印浓度。
 * @param text 水印内容。
 */
function addWatermarkText(font, size, x, y, n, text) {
    var c = {};
    c["tag"] = "BKT";
    c["font"] = font;
    c["size"] = size;
    c["x"] = x;
    c["y"] = y;
    c["n"] = n;
    c["value"] = text;

    command.push(c);
}

/**
 * 打印
 */
function addPoPrint() {
    var c = {};
    c["tag"] = "POPRINT";
    command.push(c);
}

/**
 * 打印
 */
function addPrint() {
    var c = {};
    c["tag"] = "PRINT";
    command.push(c);
}

/**
 * 清空指令
 */
function clear() {
    command = [];
}

/**
 * 获取指令
 * @returns json
 */
function getCommand() {
    return command;
}